{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 14.12.98 - 11:53:15 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMSlider, MMDesign, MMConect, MMDIBCv, MMLevel,
  MMCstDlg, MMDSPObj, MMWPlay, MMHTimer, MMUtils, MMHook, ExtCtrls,
  MMWavOut, MMSpectr;

type
  TForm1 = class(TForm)
    WavePlayer: TMMWavePlayer;
    OpenDialog: TMMWaveOpenDialog;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    Connector: TMMConnector;
    MMDesigner1: TMMDesigner;
    TrackBar: TMMSlider;
    btnStop: TButton;
    btnPlay: TButton;
    btnFile: TButton;
    btnPause: TButton;
    btnRestart: TButton;
    Timer: TMMHiTimer;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    SeekTimer: TTimer;
    btnForw: TButton;
    BtnBack: TButton;
    MMSpectrum1: TMMSpectrum;
    procedure btnFileClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnRestartClick(Sender: TObject);
    procedure WavePlayerPause(Sender: TObject);
    procedure WavePlayerStart(Sender: TObject);
    procedure WavePlayerStop(Sender: TObject);
    procedure WavePlayerRestart(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TrackBarTrackEnd(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure TrackBarTrack(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure btnForwMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnForwMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BtnBackMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BtnBackMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SeekTimerTimer(Sender: TObject);
  private
    Seeking: Boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop playing at the end }
   WavePlayer.Stop;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      WavePlayer.Wave.FileName := OpenDialog.FileName;
      btnPlay.Enabled  := not WavePlayer.Wave.Empty;
      TrackBar.Enabled := not WavePlayer.Wave.Empty;
      TrackBar.MaxValue:= WavePlayer.Wave.DataSize;
      TrackBar.Position:= 0;
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   WavePlayer.Play;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WavePlayer.Stop;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPauseClick(Sender: TObject);
begin
   WavePlayer.Pause;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnRestartClick(Sender: TObject);
begin
   WavePlayer.Restart;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WavePlayerStart(Sender: TObject);
begin
   Timer.Enabled    := True;
   btnPlay.Enabled  := False;
   btnStop.Enabled  := True;
   btnPause.Enabled := True;
   btnForw.Enabled  := True;
   btnBack.Enabled  := True;
   btnFile.Enabled  := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WavePlayerStop(Sender: TObject);
begin
   Timer.Enabled      := False;
   btnPlay.Enabled    := True;
   btnStop.Enabled    := False;
   btnPause.Enabled   := False;
   btnRestart.Enabled := False;
   btnForw.Enabled    := False;
   btnBack.Enabled    := False;
   btnFile.Enabled    := True;

   TrackBar.Position  := WavePlayer.Position;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WavePlayerPause(Sender: TObject);
begin
   btnPause.Enabled := False;
   btnRestart.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WavePlayerRestart(Sender: TObject);
begin
   btnPause.Enabled := True;
   btnRestart.Enabled := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.TrackBarChange(Sender: TObject);
begin
   Label1.Caption := TimeToString(TrackBar.Position);
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.TrackBarTrack(Sender: TObject);
begin
   Seeking := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.TrackBarTrackEnd(Sender: TObject);
begin
   WavePlayer.Position := TrackBar.Position;
   Seeking := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.TimerTimer(Sender: TObject);
begin
   if not Seeking then TrackBar.Position := WavePlayer.Position;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   WavePlayer.ResetPosition := CheckBox1.Checked;
end;

procedure TForm1.btnForwMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   SeekTimer.Tag := 0;
   SeekTimer.Enabled := True;
end;

procedure TForm1.btnForwMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   SeekTimer.Enabled := False;
end;

procedure TForm1.BtnBackMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   SeekTimer.Tag := 1;
   SeekTimer.Enabled := True;
end;

procedure TForm1.BtnBackMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   SeekTimer.Enabled := False;
end;

procedure TForm1.SeekTimerTimer(Sender: TObject);
var
   Len,PlayPos,NewPos: Longint;

begin
   if not (wosPlay in WavePlayer.State) then exit;

   len := WavePlayer.Wave.DataSize;
   PlayPos := WavePlayer.Position;

   if (SeekTimer.Tag = 0) then
   begin
      NewPos := PlayPos + 2500;
      if NewPos >= len then
         NewPos := len - 2500;
   end
   else
   begin
      NewPos := PlayPos - 2500;
      if NewPos < 0 then
         NewPos := 0;
   end;
   WavePlayer.Position := NewPos;
end;

end.
